/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.modification.chunk;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.teamabnormals.blueprint.common.world.modification.chunk.ChunkGeneratorModifierSerializers;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifierGroup;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="blueprint")
public final class ChunkGeneratorModificationManager
extends SimpleJsonResourceReloadListener {
    public static final String PATH = "dimension/chunk_generator";
    private final EnumMap<EventPriority, LinkedList<ObjectModifierGroup<ChunkGenerator, RegistryOps<JsonElement>, RegistryOps<JsonElement>>>> prioritizedModifiers = new EnumMap(EventPriority.class);
    private static ChunkGeneratorModificationManager INSTANCE;
    private final RegistryOps<JsonElement> registryOps;

    public ChunkGeneratorModificationManager(RegistryOps<JsonElement> registryOps) {
        super(new Gson(), "modifiers/dimension/chunk_generator");
        this.registryOps = registryOps;
    }

    @SubscribeEvent
    public static void onReloadListener(AddReloadListenerEvent event) {
        try {
            INSTANCE = new ChunkGeneratorModificationManager(DataUtil.createRegistryOps(event.getServerResources()));
            event.addListener((PreparableReloadListener)INSTANCE);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        RegistryOps<JsonElement> registryOps = this.registryOps;
        int groupsLoaded = 0;
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation location = entry.getKey();
            try {
                ObjectModifierGroup<ChunkGenerator, RegistryOps<JsonElement>, RegistryOps<JsonElement>> modifierGroup = ObjectModifierGroup.deserialize(location.toString(), entry.getValue().getAsJsonObject(), registryOps, ChunkGeneratorModifierSerializers.REGISTRY, true, true);
                this.prioritizedModifiers.computeIfAbsent(modifierGroup.priority(), __ -> new LinkedList()).add(modifierGroup);
                ++groupsLoaded;
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                Blueprint.LOGGER.error("Parsing error loading Chunk Generator Modifier Group: {}", (Object)location, (Object)exception);
            }
        }
        Blueprint.LOGGER.info("Chunk Generator Modification Manager has loaded {} modifier groups", (Object)groupsLoaded);
    }

    static {
        for (EventPriority priority : EventPriority.values()) {
            MinecraftForge.EVENT_BUS.addListener(event -> {
                if (INSTANCE == null) {
                    return;
                }
                EnumMap<EventPriority, LinkedList<ObjectModifierGroup<ChunkGenerator, RegistryOps<JsonElement>, RegistryOps<JsonElement>>>> prioritizedModifiers = ChunkGeneratorModificationManager.INSTANCE.prioritizedModifiers;
                if (prioritizedModifiers == null) {
                    return;
                }
                LinkedList<ObjectModifierGroup<ChunkGenerator, RegistryOps<JsonElement>, RegistryOps<JsonElement>>> modifierGroups = prioritizedModifiers.get(priority);
                if (modifierGroups == null) {
                    return;
                }
                Registry dimensions = event.getServer().m_129910_().m_5961_().m_204655_();
                Set keySet = dimensions.m_6566_();
                HashMap assignedModifiers = new HashMap();
                for (ObjectModifierGroup objectModifierGroup : modifierGroups) {
                    objectModifierGroup.selector().select(keySet::forEach).forEach(location -> assignedModifiers.computeIfAbsent(location, __ -> new LinkedList()).addAll(modifierGroup.modifiers()));
                }
                for (Map.Entry entry : dimensions.m_6579_()) {
                    LinkedList modifiers = (LinkedList)assignedModifiers.get(((ResourceKey)entry.getKey()).m_135782_());
                    if (modifiers == null) continue;
                    ChunkGenerator chunkGenerator = ((LevelStem)entry.getValue()).m_63990_();
                    modifiers.forEach(configured -> configured.modify(chunkGenerator));
                }
            });
        }
    }
}

